<?php
/**
 * ALIPAY API: alipay.acquire.cancel request
 *
 * @author auto create
 * @since  1.0, 2019-03-08 15:29:11
 */

namespace xsframe\pay\Alipay\Request;
class AlipayAcquireCancelRequest
{
    /**
     * 操作员ID。
     **/
    private $operatorId;

    /**
     * 操作员的类型：
     * 0：支付宝操作员
     * 1：商户的操作员
     * 如果传入其它值或者为空，则默认设置为1
     **/
    private $operatorType;

    /**
     * 支付宝合作商户网站唯一订单号。
     **/
    private $outTradeNo;

    /**
     * 该交易在支付宝系统中的交易流水号。
     * 最短16位，最长64位。
     * 如果同时传了out_trade_no和trade_no，则以trade_no为准。
     **/
    private $tradeNo;

    private $apiParas    = [];
    private $terminalType;
    private $terminalInfo;
    private $prodCode;
    private $apiVersion  = "1.0";
    private $notifyUrl;
    private $returnUrl;
    private $needEncrypt = false;


    public function setOperatorId($operatorId)
    {
        $this->operatorId              = $operatorId;
        $this->apiParas["operator_id"] = $operatorId;
    }

    public function getOperatorId()
    {
        return $this->operatorId;
    }

    public function setOperatorType($operatorType)
    {
        $this->operatorType              = $operatorType;
        $this->apiParas["operator_type"] = $operatorType;
    }

    public function getOperatorType()
    {
        return $this->operatorType;
    }

    public function setOutTradeNo($outTradeNo)
    {
        $this->outTradeNo               = $outTradeNo;
        $this->apiParas["out_trade_no"] = $outTradeNo;
    }

    public function getOutTradeNo()
    {
        return $this->outTradeNo;
    }

    public function setTradeNo($tradeNo)
    {
        $this->tradeNo              = $tradeNo;
        $this->apiParas["trade_no"] = $tradeNo;
    }

    public function getTradeNo()
    {
        return $this->tradeNo;
    }

    public function getApiMethodName()
    {
        return "alipay.acquire.cancel";
    }

    public function setNotifyUrl($notifyUrl)
    {
        $this->notifyUrl = $notifyUrl;
    }

    public function getNotifyUrl()
    {
        return $this->notifyUrl;
    }

    public function setReturnUrl($returnUrl)
    {
        $this->returnUrl = $returnUrl;
    }

    public function getReturnUrl()
    {
        return $this->returnUrl;
    }

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getTerminalType()
    {
        return $this->terminalType;
    }

    public function setTerminalType($terminalType)
    {
        $this->terminalType = $terminalType;
    }

    public function getTerminalInfo()
    {
        return $this->terminalInfo;
    }

    public function setTerminalInfo($terminalInfo)
    {
        $this->terminalInfo = $terminalInfo;
    }

    public function getProdCode()
    {
        return $this->prodCode;
    }

    public function setProdCode($prodCode)
    {
        $this->prodCode = $prodCode;
    }

    public function setApiVersion($apiVersion)
    {
        $this->apiVersion = $apiVersion;
    }

    public function getApiVersion()
    {
        return $this->apiVersion;
    }

    public function setNeedEncrypt($needEncrypt)
    {

        $this->needEncrypt = $needEncrypt;

    }

    public function getNeedEncrypt()
    {
        return $this->needEncrypt;
    }

}
