<?php


namespace app\admin\controller;


use think\facade\Config;
use xsframe\base\AdminBaseController;
use xsframe\facade\wrapper\SystemWrapperFacade;
use xsframe\wrapper\UserWrapper;

class Base extends AdminBaseController
{
    public function _admin_initialize()
    {
        parent::_admin_initialize(); // TODO: Change the autogenerated stub
        $this->checkRouter();
    }

    // 防止普通用户进入超级管理后台
    public function checkRouter()
    {
        $isAdmin = $this->module == 'admin'; // 是否超级管理后台
        $notUtil = strtolower($this->controller) != 'util'; // 工具类
        $notSetDefaultModule = strtolower($this->controller) != 'system' && $this->action != 'setAccountDefaultModule'; // 是否设置默认模块

        if ($isAdmin && $notUtil && $notSetDefaultModule) {
            $adminSession = $this->adminSession;

            if (!empty($adminSession)) {

                # 非管理员用户一律不得进入平台端
                if ($adminSession['role'] != 'owner' && $this->controller != 'login') {

                    $moduleInfo = UserWrapper::getModuleInfoByUserId($this->adminSession['uid']);
                    $uniacid = $moduleInfo['uniacid'];
                    $moduleName = $moduleInfo['module'];
                    if (!empty($moduleName)) {

                        # 1.验证码管理员访问当前应用是否还有权限，如果没有就进入到商户管理页面
                        if ($adminSession['role'] == 'manager') {
                            $accountModuleList = SystemWrapperFacade::getAccountModuleList($uniacid);
                            if (!in_array($moduleName, $accountModuleList)) {
                                header('location: ' . webUrl('admin/system/index', ['i' => $uniacid]));
                                exit();
                            }
                        }

                        $realUrl = UserWrapper::getModuleOneUrl($moduleName, true, $adminSession['role'], $adminSession['uid']);
                        $url = webUrl(strval($realUrl), ['i' => $uniacid]);
                        header('location: ' . $url);
                    } else {
                        header('location: ' . url('/admin/error/index', ['type' => 403]));
                    }
                    exit();
                }

            }
        }
    }
}