<?php


namespace xsframe\enum;

use xsframe\base\BaseEnum;

class AppTypesKeyEnum extends BaseEnum
{
    # wechat
    const wechat_code = 'wechat';

    # wxapp
    const WXAPP_CODE = 'wxapp';

    # pc
    const PC_CODE = 'pc';

    # h5
    const H5_CODE = 'h5';

    # app
    const APP_CODE = 'app';

    # aliapp
    const ALIAPP_CODE = 'aliapp';

    # bdapp
    const BDAPP_CODE = 'bdapp';

    # uniapp
    const UNIAPP_CODE = 'uniapp';

    # 鸿蒙系统
    const HARMONYOS_CODE = 'harmonyos';

    # 抖音小程序
    const DYAPP_CODE = 'dyapp';

    # ai应用
    const AI_CODE = 'aiapp';

    // 获取全部名称
    public static function getEnumsText()
    {
        $enumsValuesList = parent::getEnumsValues();
        $newEnumsList = [];

        foreach ($enumsValuesList as $key => $item) {
            $newEnumsList[$item] = self::getText($item);
        }
        return $newEnumsList;
    }

    /**
     * 获取文本列表
     * @param string $typeString
     * @return array
     */
    public static function getTextArray(string $typeString): array
    {
        $appTypes = explode(",", $typeString);
        $newAppTypes = [];
        foreach ($appTypes as $type) {
            $newAppTypes[$type] = self::getText($type);
        }
        return $newAppTypes;
    }

    /**
     * 获得应用分类文字
     *
     * @param int $reason
     * @return string
     */
    public static function getText(string $type): string
    {
        $list = [
            self::wechat_code    => '微信公众号',
            self::WXAPP_CODE     => '微信小程序',
            self::PC_CODE        => 'PC',
            self::H5_CODE        => 'H5',
            self::APP_CODE       => 'APP',
            self::ALIAPP_CODE    => '支付宝小程序',
            self::BDAPP_CODE     => '百度小程序',
            self::UNIAPP_CODE    => 'uni-app',
            self::HARMONYOS_CODE => '鸿蒙OS',
            self::DYAPP_CODE     => '抖音小程序',
            self::AI_CODE        => 'AI应用',
        ];
        return array_key_exists($type, $list) ? $list[$type] : '';
    }

    /**
     * 获取应用分类的全部类型值
     * @param bool $format
     * @return array|mixed
     * @throws \ReflectionException
     */
    public static function getEnumsValues(bool $format = true)
    {
        return parent::getEnumsValues($format); // TODO: Change the autogenerated stub
    }
}